/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#ifndef MX__MEMORY_POOL_H
#define MX__MEMORY_POOL_H

struct mx__memory_pool
{
  char *base;
  int length; /* total number of bytes */
  int max; /* length of maximum allocation */
  mx__block block;
};

void mx__memory_pool_init(struct mx__memory_pool *pool, char *base,
			  int length, int max);
char *mx__memory_pool_alloc(struct mx__memory_pool *pool, int length);
void mx__memory_pool_free(struct mx__memory_pool *pool, char *p,
			  int length);

#endif
